#!/usr/bin/env python

# Copyright (C) 2017 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the 'License');
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an 'AS IS' BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import collections, sys

TYPES = {
    "AID_MEDIA_AUDIO": ["aac","aac","amr","awb","snd","flac","flac","mp3","mpga","mpega","mp2","m4a","aif","aiff","aifc","gsm","mka","m3u","wma","wax","ra","rm","ram","ra","pls","sd2","wav","ogg","oga"],
    "AID_MEDIA_VIDEO": ["3gpp","3gp","3gpp2","3g2","avi","dl","dif","dv","fli","m4v","ts","mpeg","mpg","mpe","mp4","vob","qt","mov","mxu","webm","lsf","lsx","mkv","mng","asf","asx","wm","wmv","wmx","wvx","movie","wrf"],
    "AID_MEDIA_IMAGE": ["bmp","gif","jpg","jpeg","jpe","pcx","png","svg","svgz","tiff","tif","wbmp","webp","dng","cr2","ras","art","jng","nef","nrw","orf","rw2","pef","psd","pnm","pbm","pgm","ppm","srw","arw","rgb","xbm","xpm","xwd"]
}

if "--rc" in sys.argv:
    print "on early-boot"
    print "    mkdir /config/sdcardfs/extensions/1055"
    print "    mkdir /config/sdcardfs/extensions/1056"
    print "    mkdir /config/sdcardfs/extensions/1057"
    for gid, exts in TYPES.iteritems():
        if gid is "AID_MEDIA_AUDIO": gid = "1055"
        if gid is "AID_MEDIA_VIDEO": gid = "1056"
        if gid is "AID_MEDIA_IMAGE": gid = "1057"
        for ext in exts:
            print "    mkdir /config/sdcardfs/extensions/%s/%s" % (gid, ext)
    exit()

print """/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/******************************************************************
 * THIS CODE WAS GENERATED BY matchgen.py, DO NOT MODIFY DIRECTLY *
 ******************************************************************/

#include <private/android_filesystem_config.h>

int MatchExtension(const char* ext) {
"""

trie = collections.defaultdict(lambda: collections.defaultdict(lambda: collections.defaultdict(lambda: collections.defaultdict(lambda: collections.defaultdict(lambda: collections.defaultdict(lambda: ""))))))

for t in TYPES:
    for v in TYPES[t]:
        v = v.lower()
        target = trie
        for c in v:
            target = target[c]
        target["\0"] = t

def dump(target, index):
    prefix = "    " * (index + 1)
    print "%sswitch (ext[%d]) {" % (prefix, index)
    for k in sorted(target.keys()):
        if k == "\0":
            print "%scase '\\0': return %s;" % (prefix, target[k])
        else:
            upper = k.upper()
            if k != upper:
                print "%scase '%s': case '%s':" % (prefix, k, upper)
            else:
                print "%scase '%s':" % (prefix, k)
            dump(target[k], index + 1)
    print "%s}" % (prefix)
    if index > 0:
        print "%sbreak;" % (prefix)

dump(trie, 0)

print """
    return 0;
}
"""
