// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "ctest.h"

#define TEST_ENUM_VALUES \
    TEST_ENUM_VALUE_A, \
    TEST_ENUM_VALUE_B

MU_DEFINE_ENUM(TEST_ENUM, TEST_ENUM_VALUES)
MU_DEFINE_ENUM_STRINGS(TEST_ENUM, TEST_ENUM_VALUES)
CTEST_DEFINE_ENUM_TYPE(TEST_ENUM, TEST_ENUM_VALUES)

#define TEST_ENUM_2_VALUES \
    TEST_ENUM_2_VALUE_A, 0, \
    TEST_ENUM_2_VALUE_B, 1

MU_DEFINE_ENUM_2(TEST_ENUM_2, TEST_ENUM_2_VALUES)
MU_DEFINE_ENUM_STRINGS_2(TEST_ENUM_2, TEST_ENUM_2_VALUES)
CTEST_DEFINE_ENUM_2_TYPE(TEST_ENUM_2, TEST_ENUM_2_VALUES)

CTEST_BEGIN_TEST_SUITE(enum_define_tests)

CTEST_FUNCTION(Compare_enum_exists)
{
    CTEST_ASSERT_ARE_EQUAL(TEST_ENUM, TEST_ENUM_VALUE_A, TEST_ENUM_VALUE_A);
}

CTEST_FUNCTION(ToString_gets_used)
{
    CTEST_ASSERT_ARE_EQUAL(TEST_ENUM, TEST_ENUM_VALUE_A, TEST_ENUM_VALUE_B);
}

CTEST_FUNCTION(Compare_enum_2_Exists)
{
    CTEST_ASSERT_ARE_EQUAL(TEST_ENUM_2, TEST_ENUM_2_VALUE_A, TEST_ENUM_2_VALUE_A);
}

CTEST_FUNCTION(ToString_for_enum_2_gets_used)
{
    CTEST_ASSERT_ARE_EQUAL(TEST_ENUM_2, TEST_ENUM_2_VALUE_A, TEST_ENUM_2_VALUE_B);
}

CTEST_END_TEST_SUITE(enum_define_tests)
