# Contributing to BOINC
:+1: First off, thank you for taking the time to contribute! It's people like you that make BOINC such a great tool. :+1:

## How Can I Contribute?

### Get Connected
Want to connect with contributors?
* Join us on [Slack](https://join.slack.com/t/boincworkspace/shared_invite/enQtNzA3MTQ4NDA0Njc4LTM4NTEyZTY1MWEwZjAyNTVmOTg3NDA2NjVjZDQzMWQ3NmFjYTc4MTNkNTEyNjRkOTQ4MWU5Nzk3NzRhNTg0NDI)
* Join the email lists:
  * [BOINC Overall](https://groups.google.com/forum/#!forum/boinc_admin)
  * [BOINC Projects](https://groups.google.com/a/ssl.berkeley.edu/forum/#!forum/boinc_projects)
  * [BOINC Development](https://groups.google.com/a/ssl.berkeley.edu/forum/#!forum/boinc_dev)
  * [BOINC Alpha Testing](https://groups.google.com/a/ssl.berkeley.edu/forum/#!forum/boinc_alpha)
* Join one of the community calls:
  * The BOINC Projects call occurs quarterly and is announced on the [BOINC Projects email list](https://groups.google.com/a/ssl.berkeley.edu/forum/#!forum/boinc_projects)
  * The BOINC Contributor call occurs every other week and is announced on the [BOINC Development email list](https://groups.google.com/a/ssl.berkeley.edu/forum/#!forum/boinc_dev)

### Promote Volunteer Computing
Want to help promote volunteer computing and work on ways to attract new users? Join the #communications channel on [Slack](https://join.slack.com/t/boincworkspace/shared_invite/enQtNzA3MTQ4NDA0Njc4LTM4NTEyZTY1MWEwZjAyNTVmOTg3NDA2NjVjZDQzMWQ3NmFjYTc4MTNkNTEyNjRkOTQ4MWU5Nzk3NzRhNTg0NDI)  

### Help Translate
See: https://boinc.berkeley.edu/trac/wiki/TranslateIntro

### Help Test
You can help new versions of the client.  
* Become an [Alpha Tester](https://boinc.berkeley.edu/trac/wiki/AlphaInstructions)
* Signup to be a [BOINC Android Tester](https://groups.google.com/forum/#!forum/boinc-android-testing)

### Report Bugs
Did you find a bug? Make a Bug report.
* Ensure the bug was not already reported by searching on GitHub under [Issues](https://github.com/BOINC/boinc/issues).
* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/BOINC/boinc/issues/new).

### Suggest Enhancements
Do you have a feature idea? Make a feature request.
* Ensure the feature was not already requested by searching on GitHub under [Issues](https://github.com/BOINC/boinc/issues).
* If you're unable to find an open issue addressing the idea, [open a new one](https://github.com/BOINC/boinc/issues/new).

### Contribute Code
Do you want to fix a bug or implement a new feature?  Read about how to [implement a code contribution](https://github.com/BOINC/boinc-policy/blob/master/Development_Documents/Development_Workflow.md#2-implementation).

## Styleguides

### BOINC Coding Styles
See https://boinc.berkeley.edu/trac/wiki/CodingStyle

### Git Commit Messages
* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")


Thanks! :heart:

BOINC Team
