package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// CassandraResourcesClient is the client for the CassandraResources methods of the Documentdb service.
type CassandraResourcesClient struct {
	BaseClient
}

// NewCassandraResourcesClient creates an instance of the CassandraResourcesClient client.
func NewCassandraResourcesClient(subscriptionID string) CassandraResourcesClient {
	return NewCassandraResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCassandraResourcesClientWithBaseURI creates an instance of the CassandraResourcesClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewCassandraResourcesClientWithBaseURI(baseURI string, subscriptionID string) CassandraResourcesClient {
	return CassandraResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateUpdateCassandraKeyspace create or update an Azure Cosmos DB Cassandra keyspace
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// createUpdateCassandraKeyspaceParameters - the parameters to provide for the current Cassandra keyspace.
func (client CassandraResourcesClient) CreateUpdateCassandraKeyspace(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, createUpdateCassandraKeyspaceParameters CassandraKeyspaceCreateUpdateParameters) (result CassandraResourcesCreateUpdateCassandraKeyspaceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.CreateUpdateCassandraKeyspace")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateCassandraKeyspaceParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateCassandraKeyspaceParameters.CassandraKeyspaceCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateCassandraKeyspaceParameters.CassandraKeyspaceCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateCassandraKeyspaceParameters.CassandraKeyspaceCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "CreateUpdateCassandraKeyspace", err.Error())
	}

	req, err := client.CreateUpdateCassandraKeyspacePreparer(ctx, resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "CreateUpdateCassandraKeyspace", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateCassandraKeyspaceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "CreateUpdateCassandraKeyspace", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateCassandraKeyspacePreparer prepares the CreateUpdateCassandraKeyspace request.
func (client CassandraResourcesClient) CreateUpdateCassandraKeyspacePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, createUpdateCassandraKeyspaceParameters CassandraKeyspaceCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}", pathParameters),
		autorest.WithJSON(createUpdateCassandraKeyspaceParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateCassandraKeyspaceSender sends the CreateUpdateCassandraKeyspace request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) CreateUpdateCassandraKeyspaceSender(req *http.Request) (future CassandraResourcesCreateUpdateCassandraKeyspaceFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateCassandraKeyspaceResponder handles the response to the CreateUpdateCassandraKeyspace request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) CreateUpdateCassandraKeyspaceResponder(resp *http.Response) (result CassandraKeyspaceGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateCassandraTable create or update an Azure Cosmos DB Cassandra Table
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
// createUpdateCassandraTableParameters - the parameters to provide for the current Cassandra Table.
func (client CassandraResourcesClient) CreateUpdateCassandraTable(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, createUpdateCassandraTableParameters CassandraTableCreateUpdateParameters) (result CassandraResourcesCreateUpdateCassandraTableFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.CreateUpdateCassandraTable")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateCassandraTableParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateCassandraTableParameters.CassandraTableCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateCassandraTableParameters.CassandraTableCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateCassandraTableParameters.CassandraTableCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "CreateUpdateCassandraTable", err.Error())
	}

	req, err := client.CreateUpdateCassandraTablePreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "CreateUpdateCassandraTable", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateCassandraTableSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "CreateUpdateCassandraTable", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateCassandraTablePreparer prepares the CreateUpdateCassandraTable request.
func (client CassandraResourcesClient) CreateUpdateCassandraTablePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, createUpdateCassandraTableParameters CassandraTableCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}", pathParameters),
		autorest.WithJSON(createUpdateCassandraTableParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateCassandraTableSender sends the CreateUpdateCassandraTable request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) CreateUpdateCassandraTableSender(req *http.Request) (future CassandraResourcesCreateUpdateCassandraTableFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateCassandraTableResponder handles the response to the CreateUpdateCassandraTable request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) CreateUpdateCassandraTableResponder(resp *http.Response) (result CassandraTableGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUpdateCassandraView create or update an Azure Cosmos DB Cassandra View
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
// createUpdateCassandraViewParameters - the parameters to provide for the current Cassandra View.
func (client CassandraResourcesClient) CreateUpdateCassandraView(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, createUpdateCassandraViewParameters CassandraViewCreateUpdateParameters) (result CassandraResourcesCreateUpdateCassandraViewFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.CreateUpdateCassandraView")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateCassandraViewParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateCassandraViewParameters.CassandraViewCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateCassandraViewParameters.CassandraViewCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateCassandraViewParameters.CassandraViewCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "createUpdateCassandraViewParameters.CassandraViewCreateUpdateProperties.Resource.ViewDefinition", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "CreateUpdateCassandraView", err.Error())
	}

	req, err := client.CreateUpdateCassandraViewPreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName, createUpdateCassandraViewParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "CreateUpdateCassandraView", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateCassandraViewSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "CreateUpdateCassandraView", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateCassandraViewPreparer prepares the CreateUpdateCassandraView request.
func (client CassandraResourcesClient) CreateUpdateCassandraViewPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, createUpdateCassandraViewParameters CassandraViewCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}", pathParameters),
		autorest.WithJSON(createUpdateCassandraViewParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateCassandraViewSender sends the CreateUpdateCassandraView request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) CreateUpdateCassandraViewSender(req *http.Request) (future CassandraResourcesCreateUpdateCassandraViewFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateCassandraViewResponder handles the response to the CreateUpdateCassandraView request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) CreateUpdateCassandraViewResponder(resp *http.Response) (result CassandraViewGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCassandraKeyspace deletes an existing Azure Cosmos DB Cassandra keyspace.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) DeleteCassandraKeyspace(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result CassandraResourcesDeleteCassandraKeyspaceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.DeleteCassandraKeyspace")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "DeleteCassandraKeyspace", err.Error())
	}

	req, err := client.DeleteCassandraKeyspacePreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "DeleteCassandraKeyspace", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteCassandraKeyspaceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "DeleteCassandraKeyspace", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteCassandraKeyspacePreparer prepares the DeleteCassandraKeyspace request.
func (client CassandraResourcesClient) DeleteCassandraKeyspacePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCassandraKeyspaceSender sends the DeleteCassandraKeyspace request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) DeleteCassandraKeyspaceSender(req *http.Request) (future CassandraResourcesDeleteCassandraKeyspaceFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteCassandraKeyspaceResponder handles the response to the DeleteCassandraKeyspace request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) DeleteCassandraKeyspaceResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteCassandraTable deletes an existing Azure Cosmos DB Cassandra table.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
func (client CassandraResourcesClient) DeleteCassandraTable(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result CassandraResourcesDeleteCassandraTableFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.DeleteCassandraTable")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "DeleteCassandraTable", err.Error())
	}

	req, err := client.DeleteCassandraTablePreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "DeleteCassandraTable", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteCassandraTableSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "DeleteCassandraTable", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteCassandraTablePreparer prepares the DeleteCassandraTable request.
func (client CassandraResourcesClient) DeleteCassandraTablePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCassandraTableSender sends the DeleteCassandraTable request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) DeleteCassandraTableSender(req *http.Request) (future CassandraResourcesDeleteCassandraTableFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteCassandraTableResponder handles the response to the DeleteCassandraTable request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) DeleteCassandraTableResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteCassandraView deletes an existing Azure Cosmos DB Cassandra view.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
func (client CassandraResourcesClient) DeleteCassandraView(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result CassandraResourcesDeleteCassandraViewFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.DeleteCassandraView")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "DeleteCassandraView", err.Error())
	}

	req, err := client.DeleteCassandraViewPreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "DeleteCassandraView", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteCassandraViewSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "DeleteCassandraView", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteCassandraViewPreparer prepares the DeleteCassandraView request.
func (client CassandraResourcesClient) DeleteCassandraViewPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCassandraViewSender sends the DeleteCassandraView request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) DeleteCassandraViewSender(req *http.Request) (future CassandraResourcesDeleteCassandraViewFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteCassandraViewResponder handles the response to the DeleteCassandraView request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) DeleteCassandraViewResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetCassandraKeyspace gets the Cassandra keyspaces under an existing Azure Cosmos DB database account with the
// provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) GetCassandraKeyspace(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result CassandraKeyspaceGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.GetCassandraKeyspace")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "GetCassandraKeyspace", err.Error())
	}

	req, err := client.GetCassandraKeyspacePreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraKeyspace", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCassandraKeyspaceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraKeyspace", resp, "Failure sending request")
		return
	}

	result, err = client.GetCassandraKeyspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraKeyspace", resp, "Failure responding to request")
		return
	}

	return
}

// GetCassandraKeyspacePreparer prepares the GetCassandraKeyspace request.
func (client CassandraResourcesClient) GetCassandraKeyspacePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCassandraKeyspaceSender sends the GetCassandraKeyspace request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) GetCassandraKeyspaceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCassandraKeyspaceResponder handles the response to the GetCassandraKeyspace request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) GetCassandraKeyspaceResponder(resp *http.Response) (result CassandraKeyspaceGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCassandraKeyspaceThroughput gets the RUs per second of the Cassandra Keyspace under an existing Azure Cosmos DB
// database account with the provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) GetCassandraKeyspaceThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result ThroughputSettingsGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.GetCassandraKeyspaceThroughput")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "GetCassandraKeyspaceThroughput", err.Error())
	}

	req, err := client.GetCassandraKeyspaceThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraKeyspaceThroughput", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCassandraKeyspaceThroughputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraKeyspaceThroughput", resp, "Failure sending request")
		return
	}

	result, err = client.GetCassandraKeyspaceThroughputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraKeyspaceThroughput", resp, "Failure responding to request")
		return
	}

	return
}

// GetCassandraKeyspaceThroughputPreparer prepares the GetCassandraKeyspaceThroughput request.
func (client CassandraResourcesClient) GetCassandraKeyspaceThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCassandraKeyspaceThroughputSender sends the GetCassandraKeyspaceThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) GetCassandraKeyspaceThroughputSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCassandraKeyspaceThroughputResponder handles the response to the GetCassandraKeyspaceThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) GetCassandraKeyspaceThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCassandraTable gets the Cassandra table under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
func (client CassandraResourcesClient) GetCassandraTable(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result CassandraTableGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.GetCassandraTable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "GetCassandraTable", err.Error())
	}

	req, err := client.GetCassandraTablePreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraTable", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCassandraTableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraTable", resp, "Failure sending request")
		return
	}

	result, err = client.GetCassandraTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraTable", resp, "Failure responding to request")
		return
	}

	return
}

// GetCassandraTablePreparer prepares the GetCassandraTable request.
func (client CassandraResourcesClient) GetCassandraTablePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCassandraTableSender sends the GetCassandraTable request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) GetCassandraTableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCassandraTableResponder handles the response to the GetCassandraTable request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) GetCassandraTableResponder(resp *http.Response) (result CassandraTableGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCassandraTableThroughput gets the RUs per second of the Cassandra table under an existing Azure Cosmos DB
// database account with the provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
func (client CassandraResourcesClient) GetCassandraTableThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result ThroughputSettingsGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.GetCassandraTableThroughput")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "GetCassandraTableThroughput", err.Error())
	}

	req, err := client.GetCassandraTableThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraTableThroughput", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCassandraTableThroughputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraTableThroughput", resp, "Failure sending request")
		return
	}

	result, err = client.GetCassandraTableThroughputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraTableThroughput", resp, "Failure responding to request")
		return
	}

	return
}

// GetCassandraTableThroughputPreparer prepares the GetCassandraTableThroughput request.
func (client CassandraResourcesClient) GetCassandraTableThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCassandraTableThroughputSender sends the GetCassandraTableThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) GetCassandraTableThroughputSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCassandraTableThroughputResponder handles the response to the GetCassandraTableThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) GetCassandraTableThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCassandraView gets the Cassandra view under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
func (client CassandraResourcesClient) GetCassandraView(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result CassandraViewGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.GetCassandraView")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "GetCassandraView", err.Error())
	}

	req, err := client.GetCassandraViewPreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraView", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCassandraViewSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraView", resp, "Failure sending request")
		return
	}

	result, err = client.GetCassandraViewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraView", resp, "Failure responding to request")
		return
	}

	return
}

// GetCassandraViewPreparer prepares the GetCassandraView request.
func (client CassandraResourcesClient) GetCassandraViewPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCassandraViewSender sends the GetCassandraView request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) GetCassandraViewSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCassandraViewResponder handles the response to the GetCassandraView request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) GetCassandraViewResponder(resp *http.Response) (result CassandraViewGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCassandraViewThroughput gets the RUs per second of the Cassandra view under an existing Azure Cosmos DB database
// account with the provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
func (client CassandraResourcesClient) GetCassandraViewThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result ThroughputSettingsGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.GetCassandraViewThroughput")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "GetCassandraViewThroughput", err.Error())
	}

	req, err := client.GetCassandraViewThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraViewThroughput", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCassandraViewThroughputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraViewThroughput", resp, "Failure sending request")
		return
	}

	result, err = client.GetCassandraViewThroughputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "GetCassandraViewThroughput", resp, "Failure responding to request")
		return
	}

	return
}

// GetCassandraViewThroughputPreparer prepares the GetCassandraViewThroughput request.
func (client CassandraResourcesClient) GetCassandraViewThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}/throughputSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCassandraViewThroughputSender sends the GetCassandraViewThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) GetCassandraViewThroughputSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetCassandraViewThroughputResponder handles the response to the GetCassandraViewThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) GetCassandraViewThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCassandraKeyspaces lists the Cassandra keyspaces under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client CassandraResourcesClient) ListCassandraKeyspaces(ctx context.Context, resourceGroupName string, accountName string) (result CassandraKeyspaceListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.ListCassandraKeyspaces")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "ListCassandraKeyspaces", err.Error())
	}

	req, err := client.ListCassandraKeyspacesPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraKeyspaces", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCassandraKeyspacesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraKeyspaces", resp, "Failure sending request")
		return
	}

	result, err = client.ListCassandraKeyspacesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraKeyspaces", resp, "Failure responding to request")
		return
	}

	return
}

// ListCassandraKeyspacesPreparer prepares the ListCassandraKeyspaces request.
func (client CassandraResourcesClient) ListCassandraKeyspacesPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCassandraKeyspacesSender sends the ListCassandraKeyspaces request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) ListCassandraKeyspacesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListCassandraKeyspacesResponder handles the response to the ListCassandraKeyspaces request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) ListCassandraKeyspacesResponder(resp *http.Response) (result CassandraKeyspaceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCassandraTables lists the Cassandra table under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) ListCassandraTables(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result CassandraTableListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.ListCassandraTables")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "ListCassandraTables", err.Error())
	}

	req, err := client.ListCassandraTablesPreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraTables", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCassandraTablesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraTables", resp, "Failure sending request")
		return
	}

	result, err = client.ListCassandraTablesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraTables", resp, "Failure responding to request")
		return
	}

	return
}

// ListCassandraTablesPreparer prepares the ListCassandraTables request.
func (client CassandraResourcesClient) ListCassandraTablesPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCassandraTablesSender sends the ListCassandraTables request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) ListCassandraTablesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListCassandraTablesResponder handles the response to the ListCassandraTables request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) ListCassandraTablesResponder(resp *http.Response) (result CassandraTableListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCassandraViews lists the Cassandra materialized views under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) ListCassandraViews(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result CassandraViewListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.ListCassandraViews")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "ListCassandraViews", err.Error())
	}

	req, err := client.ListCassandraViewsPreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraViews", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCassandraViewsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraViews", resp, "Failure sending request")
		return
	}

	result, err = client.ListCassandraViewsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "ListCassandraViews", resp, "Failure responding to request")
		return
	}

	return
}

// ListCassandraViewsPreparer prepares the ListCassandraViews request.
func (client CassandraResourcesClient) ListCassandraViewsPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCassandraViewsSender sends the ListCassandraViews request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) ListCassandraViewsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListCassandraViewsResponder handles the response to the ListCassandraViews request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) ListCassandraViewsResponder(resp *http.Response) (result CassandraViewListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateCassandraKeyspaceToAutoscale migrate an Azure Cosmos DB Cassandra Keyspace from manual throughput to
// autoscale
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToAutoscale(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result CassandraResourcesMigrateCassandraKeyspaceToAutoscaleFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.MigrateCassandraKeyspaceToAutoscale")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "MigrateCassandraKeyspaceToAutoscale", err.Error())
	}

	req, err := client.MigrateCassandraKeyspaceToAutoscalePreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraKeyspaceToAutoscale", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateCassandraKeyspaceToAutoscaleSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraKeyspaceToAutoscale", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateCassandraKeyspaceToAutoscalePreparer prepares the MigrateCassandraKeyspaceToAutoscale request.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToAutoscalePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default/migrateToAutoscale", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateCassandraKeyspaceToAutoscaleSender sends the MigrateCassandraKeyspaceToAutoscale request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToAutoscaleSender(req *http.Request) (future CassandraResourcesMigrateCassandraKeyspaceToAutoscaleFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateCassandraKeyspaceToAutoscaleResponder handles the response to the MigrateCassandraKeyspaceToAutoscale request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToAutoscaleResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateCassandraKeyspaceToManualThroughput migrate an Azure Cosmos DB Cassandra Keyspace from autoscale to manual
// throughput
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result CassandraResourcesMigrateCassandraKeyspaceToManualThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.MigrateCassandraKeyspaceToManualThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "MigrateCassandraKeyspaceToManualThroughput", err.Error())
	}

	req, err := client.MigrateCassandraKeyspaceToManualThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraKeyspaceToManualThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateCassandraKeyspaceToManualThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraKeyspaceToManualThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateCassandraKeyspaceToManualThroughputPreparer prepares the MigrateCassandraKeyspaceToManualThroughput request.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToManualThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default/migrateToManualThroughput", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateCassandraKeyspaceToManualThroughputSender sends the MigrateCassandraKeyspaceToManualThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToManualThroughputSender(req *http.Request) (future CassandraResourcesMigrateCassandraKeyspaceToManualThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateCassandraKeyspaceToManualThroughputResponder handles the response to the MigrateCassandraKeyspaceToManualThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) MigrateCassandraKeyspaceToManualThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateCassandraTableToAutoscale migrate an Azure Cosmos DB Cassandra table from manual throughput to autoscale
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
func (client CassandraResourcesClient) MigrateCassandraTableToAutoscale(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result CassandraResourcesMigrateCassandraTableToAutoscaleFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.MigrateCassandraTableToAutoscale")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "MigrateCassandraTableToAutoscale", err.Error())
	}

	req, err := client.MigrateCassandraTableToAutoscalePreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraTableToAutoscale", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateCassandraTableToAutoscaleSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraTableToAutoscale", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateCassandraTableToAutoscalePreparer prepares the MigrateCassandraTableToAutoscale request.
func (client CassandraResourcesClient) MigrateCassandraTableToAutoscalePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default/migrateToAutoscale", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateCassandraTableToAutoscaleSender sends the MigrateCassandraTableToAutoscale request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) MigrateCassandraTableToAutoscaleSender(req *http.Request) (future CassandraResourcesMigrateCassandraTableToAutoscaleFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateCassandraTableToAutoscaleResponder handles the response to the MigrateCassandraTableToAutoscale request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) MigrateCassandraTableToAutoscaleResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateCassandraTableToManualThroughput migrate an Azure Cosmos DB Cassandra table from autoscale to manual
// throughput
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
func (client CassandraResourcesClient) MigrateCassandraTableToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result CassandraResourcesMigrateCassandraTableToManualThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.MigrateCassandraTableToManualThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "MigrateCassandraTableToManualThroughput", err.Error())
	}

	req, err := client.MigrateCassandraTableToManualThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraTableToManualThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateCassandraTableToManualThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraTableToManualThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateCassandraTableToManualThroughputPreparer prepares the MigrateCassandraTableToManualThroughput request.
func (client CassandraResourcesClient) MigrateCassandraTableToManualThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default/migrateToManualThroughput", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateCassandraTableToManualThroughputSender sends the MigrateCassandraTableToManualThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) MigrateCassandraTableToManualThroughputSender(req *http.Request) (future CassandraResourcesMigrateCassandraTableToManualThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateCassandraTableToManualThroughputResponder handles the response to the MigrateCassandraTableToManualThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) MigrateCassandraTableToManualThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateCassandraViewToAutoscale migrate an Azure Cosmos DB Cassandra view from manual throughput to autoscale
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
func (client CassandraResourcesClient) MigrateCassandraViewToAutoscale(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result CassandraResourcesMigrateCassandraViewToAutoscaleFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.MigrateCassandraViewToAutoscale")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "MigrateCassandraViewToAutoscale", err.Error())
	}

	req, err := client.MigrateCassandraViewToAutoscalePreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraViewToAutoscale", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateCassandraViewToAutoscaleSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraViewToAutoscale", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateCassandraViewToAutoscalePreparer prepares the MigrateCassandraViewToAutoscale request.
func (client CassandraResourcesClient) MigrateCassandraViewToAutoscalePreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}/throughputSettings/default/migrateToAutoscale", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateCassandraViewToAutoscaleSender sends the MigrateCassandraViewToAutoscale request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) MigrateCassandraViewToAutoscaleSender(req *http.Request) (future CassandraResourcesMigrateCassandraViewToAutoscaleFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateCassandraViewToAutoscaleResponder handles the response to the MigrateCassandraViewToAutoscale request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) MigrateCassandraViewToAutoscaleResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateCassandraViewToManualThroughput migrate an Azure Cosmos DB Cassandra view from autoscale to manual throughput
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
func (client CassandraResourcesClient) MigrateCassandraViewToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result CassandraResourcesMigrateCassandraViewToManualThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.MigrateCassandraViewToManualThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "MigrateCassandraViewToManualThroughput", err.Error())
	}

	req, err := client.MigrateCassandraViewToManualThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraViewToManualThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateCassandraViewToManualThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "MigrateCassandraViewToManualThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigrateCassandraViewToManualThroughputPreparer prepares the MigrateCassandraViewToManualThroughput request.
func (client CassandraResourcesClient) MigrateCassandraViewToManualThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}/throughputSettings/default/migrateToManualThroughput", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateCassandraViewToManualThroughputSender sends the MigrateCassandraViewToManualThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) MigrateCassandraViewToManualThroughputSender(req *http.Request) (future CassandraResourcesMigrateCassandraViewToManualThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// MigrateCassandraViewToManualThroughputResponder handles the response to the MigrateCassandraViewToManualThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) MigrateCassandraViewToManualThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCassandraKeyspaceThroughput update RUs per second of an Azure Cosmos DB Cassandra Keyspace
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// updateThroughputParameters - the RUs per second of the parameters to provide for the current Cassandra
// Keyspace.
func (client CassandraResourcesClient) UpdateCassandraKeyspaceThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (result CassandraResourcesUpdateCassandraKeyspaceThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.UpdateCassandraKeyspaceThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: updateThroughputParameters,
			Constraints: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings.MaxThroughput", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "UpdateCassandraKeyspaceThroughput", err.Error())
	}

	req, err := client.UpdateCassandraKeyspaceThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, updateThroughputParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "UpdateCassandraKeyspaceThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateCassandraKeyspaceThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "UpdateCassandraKeyspaceThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateCassandraKeyspaceThroughputPreparer prepares the UpdateCassandraKeyspaceThroughput request.
func (client CassandraResourcesClient) UpdateCassandraKeyspaceThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default", pathParameters),
		autorest.WithJSON(updateThroughputParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCassandraKeyspaceThroughputSender sends the UpdateCassandraKeyspaceThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) UpdateCassandraKeyspaceThroughputSender(req *http.Request) (future CassandraResourcesUpdateCassandraKeyspaceThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateCassandraKeyspaceThroughputResponder handles the response to the UpdateCassandraKeyspaceThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) UpdateCassandraKeyspaceThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCassandraTableThroughput update RUs per second of an Azure Cosmos DB Cassandra table
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// tableName - cosmos DB table name.
// updateThroughputParameters - the RUs per second of the parameters to provide for the current Cassandra
// table.
func (client CassandraResourcesClient) UpdateCassandraTableThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (result CassandraResourcesUpdateCassandraTableThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.UpdateCassandraTableThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: updateThroughputParameters,
			Constraints: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings.MaxThroughput", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "UpdateCassandraTableThroughput", err.Error())
	}

	req, err := client.UpdateCassandraTableThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "UpdateCassandraTableThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateCassandraTableThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "UpdateCassandraTableThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateCassandraTableThroughputPreparer prepares the UpdateCassandraTableThroughput request.
func (client CassandraResourcesClient) UpdateCassandraTableThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default", pathParameters),
		autorest.WithJSON(updateThroughputParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCassandraTableThroughputSender sends the UpdateCassandraTableThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) UpdateCassandraTableThroughputSender(req *http.Request) (future CassandraResourcesUpdateCassandraTableThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateCassandraTableThroughputResponder handles the response to the UpdateCassandraTableThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) UpdateCassandraTableThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCassandraViewThroughput update RUs per second of an Azure Cosmos DB Cassandra view
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// keyspaceName - cosmos DB keyspace name.
// viewName - cosmos DB view name.
// updateThroughputParameters - the RUs per second of the parameters to provide for the current Cassandra view.
func (client CassandraResourcesClient) UpdateCassandraViewThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (result CassandraResourcesUpdateCassandraViewThroughputFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CassandraResourcesClient.UpdateCassandraViewThroughput")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: updateThroughputParameters,
			Constraints: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "updateThroughputParameters.ThroughputSettingsUpdateProperties.Resource.AutoscaleSettings.MaxThroughput", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.CassandraResourcesClient", "UpdateCassandraViewThroughput", err.Error())
	}

	req, err := client.UpdateCassandraViewThroughputPreparer(ctx, resourceGroupName, accountName, keyspaceName, viewName, updateThroughputParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "UpdateCassandraViewThroughput", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateCassandraViewThroughputSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesClient", "UpdateCassandraViewThroughput", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateCassandraViewThroughputPreparer prepares the UpdateCassandraViewThroughput request.
func (client CassandraResourcesClient) UpdateCassandraViewThroughputPreparer(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, updateThroughputParameters ThroughputSettingsUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"keyspaceName":      autorest.Encode("path", keyspaceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"viewName":          autorest.Encode("path", viewName),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}/throughputSettings/default", pathParameters),
		autorest.WithJSON(updateThroughputParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCassandraViewThroughputSender sends the UpdateCassandraViewThroughput request. The method will close the
// http.Response Body if it receives an error.
func (client CassandraResourcesClient) UpdateCassandraViewThroughputSender(req *http.Request) (future CassandraResourcesUpdateCassandraViewThroughputFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateCassandraViewThroughputResponder handles the response to the UpdateCassandraViewThroughput request. The method always
// closes the http.Response Body.
func (client CassandraResourcesClient) UpdateCassandraViewThroughputResponder(resp *http.Response) (result ThroughputSettingsGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
