; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu < %s | FileCheck %s
; RUN: not --crash llc -mtriple=aarch64_be < %s

;
; bitcast to nxv16i8
;

define <vscale x 16 x i8> @bitcast_nxv8i16_to_nxv16i8(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

define <vscale x 16 x i8> @bitcast_nxv4i32_to_nxv16i8(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

define <vscale x 16 x i8> @bitcast_nxv2i64_to_nxv16i8(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

define <vscale x 16 x i8> @bitcast_nxv8f16_to_nxv16i8(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

define <vscale x 16 x i8> @bitcast_nxv4f32_to_nxv16i8(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

define <vscale x 16 x i8> @bitcast_nxv2f64_to_nxv16i8(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

define <vscale x 16 x i8> @bitcast_nxv8bf16_to_nxv16i8(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %bc
}

;
; bitcast to nxv8i16
;

define <vscale x 8 x i16> @bitcast_nxv16i8_to_nxv8i16(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

define <vscale x 8 x i16> @bitcast_nxv4i32_to_nxv8i16(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

define <vscale x 8 x i16> @bitcast_nxv2i64_to_nxv8i16(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

define <vscale x 8 x i16> @bitcast_nxv8f16_to_nxv8i16(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

define <vscale x 8 x i16> @bitcast_nxv4f32_to_nxv8i16(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

define <vscale x 8 x i16> @bitcast_nxv2f64_to_nxv8i16(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

define <vscale x 8 x i16> @bitcast_nxv8bf16_to_nxv8i16(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %bc
}

;
; bitcast to nxv4i32
;

define <vscale x 4 x i32> @bitcast_nxv16i8_to_nxv4i32(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

define <vscale x 4 x i32> @bitcast_nxv8i16_to_nxv4i32(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

define <vscale x 4 x i32> @bitcast_nxv2i64_to_nxv4i32(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

define <vscale x 4 x i32> @bitcast_nxv8f16_to_nxv4i32(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

define <vscale x 4 x i32> @bitcast_nxv4f32_to_nxv4i32(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

define <vscale x 4 x i32> @bitcast_nxv2f64_to_nxv4i32(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

define <vscale x 4 x i32> @bitcast_nxv8bf16_to_nxv4i32(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %bc
}

;
; bitcast to nxv2i64
;

define <vscale x 2 x i64> @bitcast_nxv16i8_to_nxv2i64(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

define <vscale x 2 x i64> @bitcast_nxv8i16_to_nxv2i64(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

define <vscale x 2 x i64> @bitcast_nxv4i32_to_nxv2i64(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

define <vscale x 2 x i64> @bitcast_nxv8f16_to_nxv2i64(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

define <vscale x 2 x i64> @bitcast_nxv4f32_to_nxv2i64(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

define <vscale x 2 x i64> @bitcast_nxv2f64_to_nxv2i64(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

define <vscale x 2 x i64> @bitcast_nxv8bf16_to_nxv2i64(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %bc
}

;
; bitcast to nxv8f16
;

define <vscale x 8 x half> @bitcast_nxv16i8_to_nxv8f16(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

define <vscale x 8 x half> @bitcast_nxv8i16_to_nxv8f16(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

define <vscale x 8 x half> @bitcast_nxv4i32_to_nxv8f16(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

define <vscale x 8 x half> @bitcast_nxv2i64_to_nxv8f16(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

define <vscale x 8 x half> @bitcast_nxv4f32_to_nxv8f16(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

define <vscale x 8 x half> @bitcast_nxv2f64_to_nxv8f16(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

define <vscale x 8 x half> @bitcast_nxv8bf16_to_nxv8f16(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 8 x half>
  ret <vscale x 8 x half> %bc
}

;
; bitcast to nxv4f32
;

define <vscale x 4 x float> @bitcast_nxv16i8_to_nxv4f32(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

define <vscale x 4 x float> @bitcast_nxv8i16_to_nxv4f32(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

define <vscale x 4 x float> @bitcast_nxv4i32_to_nxv4f32(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

define <vscale x 4 x float> @bitcast_nxv2i64_to_nxv4f32(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

define <vscale x 4 x float> @bitcast_nxv8f16_to_nxv4f32(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

define <vscale x 4 x float> @bitcast_nxv2f64_to_nxv4f32(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

define <vscale x 4 x float> @bitcast_nxv8bf16_to_nxv4f32(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 4 x float>
  ret <vscale x 4 x float> %bc
}

;
; bitcast to nxv2f64
;

define <vscale x 2 x double> @bitcast_nxv16i8_to_nxv2f64(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

define <vscale x 2 x double> @bitcast_nxv8i16_to_nxv2f64(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

define <vscale x 2 x double> @bitcast_nxv4i32_to_nxv2f64(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

define <vscale x 2 x double> @bitcast_nxv2i64_to_nxv2f64(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

define <vscale x 2 x double> @bitcast_nxv8f16_to_nxv2f64(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

define <vscale x 2 x double> @bitcast_nxv4f32_to_nxv2f64(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

define <vscale x 2 x double> @bitcast_nxv8bf16_to_nxv2f64(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv8bf16_to_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x bfloat> %v to <vscale x 2 x double>
  ret <vscale x 2 x double> %bc
}

;
; bitcast to nxv8bf16
;

define <vscale x 8 x bfloat> @bitcast_nxv16i8_to_nxv8bf16(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv16i8_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 16 x i8> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

define <vscale x 8 x bfloat> @bitcast_nxv8i16_to_nxv8bf16(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i16_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i16> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

define <vscale x 8 x bfloat> @bitcast_nxv4i32_to_nxv8bf16(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i32_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i32> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

define <vscale x 8 x bfloat> @bitcast_nxv2i64_to_nxv8bf16(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i64_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i64> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

define <vscale x 8 x bfloat> @bitcast_nxv8f16_to_nxv8bf16(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv8f16_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x half> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

define <vscale x 8 x bfloat> @bitcast_nxv4f32_to_nxv8bf16(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f32_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x float> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

define <vscale x 8 x bfloat> @bitcast_nxv2f64_to_nxv8bf16(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f64_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x double> %v to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %bc
}

;
; bitcast to nxv8i8
;

define <vscale x 8 x i8> @bitcast_nxv4i16_to_nxv8i8(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

define <vscale x 8 x i8> @bitcast_nxv2i32_to_nxv8i8(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

define <vscale x 8 x i8> @bitcast_nxv1i64_to_nxv8i8(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

define <vscale x 8 x i8> @bitcast_nxv4f16_to_nxv8i8(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

define <vscale x 8 x i8> @bitcast_nxv2f32_to_nxv8i8(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

define <vscale x 8 x i8> @bitcast_nxv1f64_to_nxv8i8(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

define <vscale x 8 x i8> @bitcast_nxv4bf16_to_nxv8i8(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %bc
}

;
; bitcast to nxv4i16
;

define <vscale x 4 x i16> @bitcast_nxv8i8_to_nxv4i16(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1b { z0.h }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

define <vscale x 4 x i16> @bitcast_nxv2i32_to_nxv4i16(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

define <vscale x 4 x i16> @bitcast_nxv1i64_to_nxv4i16(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

define <vscale x 4 x i16> @bitcast_nxv4f16_to_nxv4i16(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

define <vscale x 4 x i16> @bitcast_nxv2f32_to_nxv4i16(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

define <vscale x 4 x i16> @bitcast_nxv1f64_to_nxv4i16(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

define <vscale x 4 x i16> @bitcast_nxv4bf16_to_nxv4i16(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %bc
}

;
; bitcast to nxv2i32
;

define <vscale x 2 x i32> @bitcast_nxv8i8_to_nxv2i32(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1b { z0.h }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

define <vscale x 2 x i32> @bitcast_nxv4i16_to_nxv2i32(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

define <vscale x 2 x i32> @bitcast_nxv1i64_to_nxv2i32(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

define <vscale x 2 x i32> @bitcast_nxv4f16_to_nxv2i32(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

define <vscale x 2 x i32> @bitcast_nxv2f32_to_nxv2i32(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

define <vscale x 2 x i32> @bitcast_nxv1f64_to_nxv2i32(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

define <vscale x 2 x i32> @bitcast_nxv4bf16_to_nxv2i32(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bc
}

;
; bitcast to nxv1i64
;

define <vscale x 1 x i64> @bitcast_nxv8i8_to_nxv1i64(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

define <vscale x 1 x i64> @bitcast_nxv4i16_to_nxv1i64(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

define <vscale x 1 x i64> @bitcast_nxv2i32_to_nxv1i64(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

define <vscale x 1 x i64> @bitcast_nxv4f16_to_nxv1i64(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

define <vscale x 1 x i64> @bitcast_nxv2f32_to_nxv1i64(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

define <vscale x 1 x i64> @bitcast_nxv1f64_to_nxv1i64(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

define <vscale x 1 x i64> @bitcast_nxv4bf16_to_nxv1i64(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %bc
}

;
; bitcast to nxv4f16
;

define <vscale x 4 x half> @bitcast_nxv8i8_to_nxv4f16(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1b { z0.h }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

define <vscale x 4 x half> @bitcast_nxv4i16_to_nxv4f16(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

define <vscale x 4 x half> @bitcast_nxv2i32_to_nxv4f16(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

define <vscale x 4 x half> @bitcast_nxv1i64_to_nxv4f16(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

define <vscale x 4 x half> @bitcast_nxv2f32_to_nxv4f16(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

define <vscale x 4 x half> @bitcast_nxv1f64_to_nxv4f16(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

define <vscale x 4 x half> @bitcast_nxv4bf16_to_nxv4f16(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 4 x half>
  ret <vscale x 4 x half> %bc
}

;
; bitcast to nxv2f32
;

define <vscale x 2 x float> @bitcast_nxv8i8_to_nxv2f32(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1b { z0.h }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

define <vscale x 2 x float> @bitcast_nxv4i16_to_nxv2f32(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

define <vscale x 2 x float> @bitcast_nxv2i32_to_nxv2f32(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

define <vscale x 2 x float> @bitcast_nxv1i64_to_nxv2f32(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

define <vscale x 2 x float> @bitcast_nxv4f16_to_nxv2f32(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

define <vscale x 2 x float> @bitcast_nxv1f64_to_nxv2f32(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

define <vscale x 2 x float> @bitcast_nxv4bf16_to_nxv2f32(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 2 x float>
  ret <vscale x 2 x float> %bc
}

;
; bitcast to nxv1f64
;

define <vscale x 1 x double> @bitcast_nxv8i8_to_nxv1f64(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

define <vscale x 1 x double> @bitcast_nxv4i16_to_nxv1f64(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

define <vscale x 1 x double> @bitcast_nxv2i32_to_nxv1f64(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

define <vscale x 1 x double> @bitcast_nxv1i64_to_nxv1f64(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

define <vscale x 1 x double> @bitcast_nxv4f16_to_nxv1f64(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

define <vscale x 1 x double> @bitcast_nxv2f32_to_nxv1f64(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

define <vscale x 1 x double> @bitcast_nxv4bf16_to_nxv1f64(<vscale x 4 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv4bf16_to_nxv1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x bfloat> %v to <vscale x 1 x double>
  ret <vscale x 1 x double> %bc
}

;
; bitcast to nxv4bf16
;

define <vscale x 4 x bfloat> @bitcast_nxv8i8_to_nxv4bf16(<vscale x 8 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv8i8_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    st1b { z0.h }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 8 x i8> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

define <vscale x 4 x bfloat> @bitcast_nxv4i16_to_nxv4bf16(<vscale x 4 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i16_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i16> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

define <vscale x 4 x bfloat> @bitcast_nxv2i32_to_nxv4bf16(<vscale x 2 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i32_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i32> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

define <vscale x 4 x bfloat> @bitcast_nxv1i64_to_nxv4bf16(<vscale x 1 x i64> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i64_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i64> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

define <vscale x 4 x bfloat> @bitcast_nxv4f16_to_nxv4bf16(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv4f16_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x half> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

define <vscale x 4 x bfloat> @bitcast_nxv2f32_to_nxv4bf16(<vscale x 2 x float> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f32_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1w { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x float> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

define <vscale x 4 x bfloat> @bitcast_nxv1f64_to_nxv4bf16(<vscale x 1 x double> %v) #0 {
; CHECK-LABEL: bitcast_nxv1f64_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x double> %v to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %bc
}

;
; bitcast to nxv4i8
;

define <vscale x 4 x i8> @bitcast_nxv2i16_to_nxv4i8(<vscale x 2 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i16_to_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1b { z0.s }, p0/z, [sp, #3, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i16> %v to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %bc
}

define <vscale x 4 x i8> @bitcast_nxv1i32_to_nxv4i8(<vscale x 1 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i32_to_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i32> %v to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %bc
}

define <vscale x 4 x i8> @bitcast_nxv2f16_to_nxv4i8(<vscale x 2 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f16_to_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1b { z0.s }, p0/z, [sp, #3, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x half> %v to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %bc
}

; @bitcast_nxv1f32_to_nxv4i8 is missing

define <vscale x 4 x i8> @bitcast_nxv2bf16_to_nxv4i8(<vscale x 2 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv2bf16_to_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1b { z0.s }, p0/z, [sp, #3, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x bfloat> %v to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %bc
}

;
; bitcast to nxv2i16
;

define <vscale x 2 x i16> @bitcast_nxv4i8_to_nxv2i16(<vscale x 4 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i8_to_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1b { z0.s }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1h { z0.d }, p0/z, [sp, #3, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i8> %v to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %bc
}

define <vscale x 2 x i16> @bitcast_nxv1i32_to_nxv2i16(<vscale x 1 x i32> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i32_to_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i32> %v to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %bc
}

define <vscale x 2 x i16> @bitcast_nxv2f16_to_nxv2i16(<vscale x 2 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f16_to_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x half> %v to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %bc
}

; @bitcast_nxv1f32_to_nxv2i16 is missing

define <vscale x 2 x i16> @bitcast_nxv2bf16_to_nxv2i16(<vscale x 2 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv2bf16_to_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x bfloat> %v to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %bc
}

;
; bitcast to nxv1i32
;

define <vscale x 1 x i32> @bitcast_nxv4i8_to_nxv1i32(<vscale x 4 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i8_to_nxv1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i8> %v to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %bc
}

define <vscale x 1 x i32> @bitcast_nxv2i16_to_nxv1i32(<vscale x 2 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i16_to_nxv1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i16> %v to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %bc
}

define <vscale x 1 x i32> @bitcast_nxv2f16_to_nxv1i32(<vscale x 2 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f16_to_nxv1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [sp]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [sp]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x half> %v to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %bc
}

; @bitcast_nxv1f32_to_nxv1i32 is missing

define <vscale x 1 x i32> @bitcast_nxv2bf16_to_nxv1i32(<vscale x 2 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv2bf16_to_nxv1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    st1h { z0.d }, p0, [sp]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [sp]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x bfloat> %v to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %bc
}

;
; bitcast to nxv2f16
;

define <vscale x 2 x half> @bitcast_nxv4i8_to_nxv2f16(<vscale x 4 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i8_to_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1b { z0.s }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1h { z0.d }, p0/z, [sp, #3, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i8> %v to <vscale x 2 x half>
  ret <vscale x 2 x half> %bc
}

define <vscale x 2 x half> @bitcast_nxv2i16_to_nxv2f16(<vscale x 2 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i16_to_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i16> %v to <vscale x 2 x half>
  ret <vscale x 2 x half> %bc
}

; @bitcast_nxv1i32_to_nxv2f16 is missing
; @bitcast_nxv1f32_to_nxv2f16 is missing

define <vscale x 2 x half> @bitcast_nxv2bf16_to_nxv2f16(<vscale x 2 x bfloat> %v) #0 {
; CHECK-LABEL: bitcast_nxv2bf16_to_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x bfloat> %v to <vscale x 2 x half>
  ret <vscale x 2 x half> %bc
}

;
; bitcast to nxv1f32
;

; @bitcast_nxv4i8_to_nxv1f32 is missing
; @bitcast_nxv2i16_to_nxv1f32 is missing
; @bitcast_nxv1i32_to_nxv1f32 is missing
; @bitcast_nxv2f16_to_nxv1f32 is missing
; @bitcast_nxv2bf16_to_nxv1f32 is missing

;
; bitcast to nxv2bf16
;

define <vscale x 2 x bfloat> @bitcast_nxv4i8_to_nxv2bf16(<vscale x 4 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv4i8_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    st1b { z0.s }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1h { z0.d }, p0/z, [sp, #3, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 4 x i8> %v to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %bc
}

define <vscale x 2 x bfloat> @bitcast_nxv2i16_to_nxv2bf16(<vscale x 2 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i16_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i16> %v to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %bc
}

; @bitcast_nxv1i32_to_nxv2bf16 is missing

define <vscale x 2 x bfloat> @bitcast_nxv2f16_to_nxv2bf16(<vscale x 2 x half> %v) #0 {
; CHECK-LABEL: bitcast_nxv2f16_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x half> %v to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %bc
}

; @bitcast_nxv1f32_to_nxv2bf16 is missing

;
; bitcast to nxv2i8
;

define <vscale x 2 x i8> @bitcast_nxv1i16_to_nxv2i8(<vscale x 1 x i16> %v) #0 {
; CHECK-LABEL: bitcast_nxv1i16_to_nxv2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 1 x i16> %v to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %bc
}

; @bitcast_nxv1f16_to_nxv2i8 is missing
; @bitcast_nxv1bf16_to_nxv2i8 is missing

;
; bitcast to nxv1i16
;

define <vscale x 1 x i16> @bitcast_nxv2i8_to_nxv1i16(<vscale x 2 x i8> %v) #0 {
; CHECK-LABEL: bitcast_nxv2i8_to_nxv1i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ret
  %bc = bitcast <vscale x 2 x i8> %v to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %bc
}

; @bitcast_nxv1f16_to_nxv1i16 is missing
; @bitcast_nxv1bf16_to_nxv1i16 is missing

;
; bitcast to nxv1f16
;

; @bitcast_nxv2i8_to_nxv1f16 is missing
; @bitcast_nxv1i16_to_nxv1f16 is missing
; @bitcast_nxv1bf16_to_nxv1f16 is missing

;
; bitcast to nxv1bf16
;

; @bitcast_nxv2i8_to_nxv1bf16 is missing
; @bitcast_nxv1i16_to_nxv1bf16 is missing
; @bitcast_nxv1f16_to_nxv1bf16 is missing

;
; Other
;

define <vscale x 2 x i32> @bitcast_short_float_to_i32(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: bitcast_short_float_to_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.s, p0/m, z0.d
; CHECK-NEXT:    ret
  %trunc = fptrunc <vscale x 2 x double> %v to <vscale x 2 x float>
  %bitcast = bitcast <vscale x 2 x float> %trunc to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %bitcast
}

define <vscale x 2 x double> @bitcast_short_i32_to_float(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: bitcast_short_i32_to_float:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %trunc = trunc <vscale x 2 x i64> %v to <vscale x 2 x i32>
  %bitcast = bitcast <vscale x 2 x i32> %trunc to <vscale x 2 x float>
  %extended = fpext <vscale x 2 x float> %bitcast to <vscale x 2 x double>
  ret <vscale x 2 x double> %extended
}

define <vscale x 2 x float> @bitcast_short_half_to_float(<vscale x 4 x half> %v) #0 {
; CHECK-LABEL: bitcast_short_half_to_float:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z0.h
; CHECK-NEXT:    st1h { z0.s }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %add = fadd <vscale x 4 x half> %v, %v
  %bitcast = bitcast <vscale x 4 x half> %add to <vscale x 2 x float>
  ret <vscale x 2 x float> %bitcast
}

; +bf16 is required for the bfloat version.
attributes #0 = { nounwind "target-features"="+sve,+bf16" }
