/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

//*****************************************************************
//  Application Gaia
//
//  Access GRIB/BUFR/NETCDF data from the Navy's storage directories
//*****************************************************************

#include <Metview.h>

class Gaia : public MvService
{
public:
    Gaia(char* name) : MvService(name) {}

    void serve(MvRequest&, MvRequest&);

    // Get some input arguments
    bool get_common_input_info(const MvRequest&);

    // Convert integer numbers to strings with '0's on the left
    void left_pad_string(const std::vector<int>&, int, std::vector<std::string>&);

    // Build the path
    bool build_path(MvRequest&);

    // Build filenames
    bool build_filenames(MvRequest&, std::vector<std::string>&);
    bool build_filenames_model(MvRequest&, std::vector<std::string>&);
    bool build_filenames_observation(MvRequest&, std::vector<std::string>&);
    bool build_filenames_ww3(MvRequest&, std::vector<std::string>&, std::vector<std::string>&);
    bool build_filenames_icon(std::vector<std::string>&, std::vector<std::string>&, std::string&,
                              std::vector<std::string>&);
    bool build_filenames_icon_single(const std::vector<std::string>&, std::vector<std::string>&);
    bool build_filenames_cosmo(std::string&, std::vector<std::string>&, std::vector<std::string>&,
                               std::vector<std::string>&);
    bool build_filenames_wrf(const std::string&, const std::string&,
                             const std::vector<std::string>&, const std::vector<std::string>&,
                             std::vector<std::string>&);
    bool build_filenames_adcirc(MvRequest&, std::vector<std::string>&);
    bool build_filenames_gfs(std::vector<std::string>&, std::vector<std::string>&,
                             std::vector<std::string>&);

    bool get_filenames(const std::string&, const std::string&, const std::string&,
                       std::vector<std::string>&);
    bool get_filenames(const std::string&, const std::string&, const std::string&,
                       const std::string&, const long, const long, std::vector<std::string>&);

    // Build output data file
    std::string bufr_obs(const std::vector<std::string>&);
    std::string grib_icon_model(const std::vector<std::string>&);
    std::string grib_icon_single_model(const std::vector<std::string>&);
    std::string grib_cosmo_wrf_gfs_model(const std::vector<std::string>&);

    // Add messages to a grib file
    bool add_messages(const std::string&, const std::string&);
    bool add_messages_tpl(const std::string&, const std::string&);

    // Split string according to a single caracter
    std::vector<std::string> split(const std::string&, char);

private:
    std::vector<std::string> dates_;
    std::vector<std::string> sparams_;
    std::vector<int> ilevels_;
    std::vector<int> times_;
    std::vector<int> isteps_;
    std::string spath_;
    std::string slevel_type_;
    float resX_{0.};
    float resY_{0.};
};
