# Changes since [3.0.3](./3.0.3.md) #

## Changes in `Glossary` code base ##

-   Fix critical bug in Glossary: `ZeroDivisionError` if `wordCount < 500`, [#61](https://github.com/ilius/pyglossary/issues/61)
-   Bug fix in Glossary.progress: make sure ui.progress is not called with a number more than 1.0
-   Fix non-working write to SQL, [#67](https://github.com/ilius/pyglossary/issues/67)
-   Bug fix & Feature: add newline argument to `Glossary.writeTxt`
    Because Python's `open` converts (modifies) newlines automatically, [#66](https://github.com/ilius/pyglossary/issues/66)
-   Break compatibility about using `Glossary.writeTxt` method
    Replace argument `sep` which was a tuple of length two, with two mandatory arguments: `sep1` and `sep2`

## Changes in plugins ##

-   Fix in StarDict plugin: fix some Python3-related errors, [#71](https://github.com/ilius/pyglossary/issues/71)
-   Fix in Dict.org plugin: `install` was not working
-   Fix in DSL plugin: replace backslash at the end of line with `<br/>`, [#61](https://github.com/ilius/pyglossary/issues/61)
-   Fix in SQL plugin: specify `encoding='utf-8'` while opening file for write, [#67](https://github.com/ilius/pyglossary/issues/67)
-   Fix in Octopus Mdict Source plugin: specify `encoding='utf-8'` while opening file for read, [#78](https://github.com/ilius/pyglossary/issues/78)
-   Fix (probable) bugs of bad newlines in 4 plugins (use `newline` argument to `Glossary.writeTxt`), [#66](https://github.com/ilius/pyglossary/issues/66)
    -   Octopus MDict Source
    -   Babylon Source (gls)
    -   Lingoes Source (LDF)
    -   Sdictionary Source (sdct)
-   Feature in Lingoes Source plugin: add `newline` write option
-   Minor fix in AppleDict plugin: fix beautifulsoup4 error message, [#72](https://github.com/ilius/pyglossary/issues/72)
-   BGL plugin: better compatibilty with Python 3.4
    Fix `CRC check failed` error for some (rare) glossaries with Python 3.4

## Other Changes ##

-   Bug fix in parsing command line read options`--read-options` and `--write-options` (happened in very rare cases)
-   Fix wrong shebang line in setup.py: must run with python3, fix [#75](https://github.com/ilius/pyglossary/issues/75)
-   Update `pyglossary.spec`
-   Change Categories for `pyglossary.desktop`

