"""hug/defaults.py

Defines and stores Hug's default handlers

Copyright (C) 2016  Timothy Edmund Crosley

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

"""
from __future__ import absolute_import

import hug

output_format = hug.output_format.json
cli_output_format = hug.output_format.text

input_format = {
    "application/json": hug.input_format.json,
    "application/x-www-form-urlencoded": hug.input_format.urlencoded,
    "multipart/form-data": hug.input_format.multipart,
    "text/plain": hug.input_format.text,
    "text/css": hug.input_format.text,
    "text/html": hug.input_format.text,
}

directives = {
    "timer": hug.directives.Timer,
    "api": hug.directives.api,
    "module": hug.directives.module,
    "current_api": hug.directives.CurrentAPI,
    "api_version": hug.directives.api_version,
    "user": hug.directives.user,
    "session": hug.directives.session,
    "documentation": hug.directives.documentation,
}


def context_factory(*args, **kwargs):
    return dict()


def delete_context(context, exception=None, errors=None, lacks_requirement=None):
    del context
