# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class SupportingDocumentTypeTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_document_types.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/SupportingDocumentTypes',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "supporting_document_types": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "supporting_document_types"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_document_types.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "supporting_document_types": [
                    {
                        "url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "fields": [
                            {
                                "machine_name": "address_sids",
                                "friendly_name": "Address Sids",
                                "constraint": "List"
                            }
                        ],
                        "machine_name": "customer_profile_address",
                        "friendly_name": "Customer profile address",
                        "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    },
                    {
                        "url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "fields": [
                            {
                                "machine_name": "first_name",
                                "friendly_name": "First Name",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "last_name",
                                "friendly_name": "Last Name",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "business_name",
                                "friendly_name": "Business Name",
                                "constraint": "String"
                            }
                        ],
                        "machine_name": "government_issued_proof_of_authorized_representative",
                        "friendly_name": "Government Issued Identity certifying proof of being an authorized representative of a company",
                        "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "supporting_document_types"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_document_types.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.supporting_document_types("OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/SupportingDocumentTypes/OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "url": "https://trusthub.twilio.com/v1/SupportingDocumentTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "fields": [
                    {
                        "machine_name": "first_name",
                        "friendly_name": "First Name",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "last_name",
                        "friendly_name": "Last Name",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "business_name",
                        "friendly_name": "Business Name",
                        "constraint": "String"
                    }
                ],
                "machine_name": "government_issued_proof_of_authorized_representative",
                "friendly_name": "Government Issued Identity certifying proof of being an authorized representative of a company",
                "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.trusthub.v1.supporting_document_types("OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)
