% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjective_animal.R
\name{adjective_animal}
\alias{adjective_animal}
\title{Ids based on a number of adjectives and an animal}
\usage{
adjective_animal(n = 1, n_adjectives = 1, style = "snake",
  max_len = Inf)
}
\arguments{
\item{n}{number of ids to return.  If \code{NULL}, it instead
returns the generating function}

\item{n_adjectives}{Number of adjectives to prefix the anmial with}

\item{style}{Style to join words with.  Can be one of "Pascal",
"camel", "snake", "kebab", "dot", "title", "sentence", "lower",
"upper", and "constant".}

\item{max_len}{The maximum length of a word part to include (this
may be useful because some of the names are rather long.  This
stops you generating a
\code{hexakosioihexekontahexaphobic_queenalexandrasbirdwingbutterfly}).
A vector of length 2 can be passed in here in which case the
first element will apply to the adjectives (all of them) and the
second element will apply to the animals.}
}
\description{
Ids based on a number of adjectives and an animal
}
\details{
The list of adjectives and animals comes from
\url{https://github.com/a-type/adjective-adjective-animal}, and in
turn from \url{gfycat.com}
}
\examples{
# Generate a random identifier:
adjective_animal()

# Generate a bunch all at once:
adjective_animal(5)

# Control the style of punctuation with the style argument:
adjective_animal(style = "lower")
adjective_animal(style = "CONSTANT")
adjective_animal(style = "camel")
adjective_animal(style = "kebab")

# Control the number of adjectives used
adjective_animal(n_adjectives = 3)

# This can get out of hand quickly though:
adjective_animal(n_adjectives = 7)

# Limit the length of adjectives and animals used:
adjective_animal(10, max_len = 6)

# The lengths can be controlled for adjectives and animals
# separately, with Inf meaning no limit:
adjective_animal(10, max_len = c(6, Inf), n_adjectives = 2)

# Pass n = NULL to bind arguments to a function
id <- adjective_animal(NULL, n_adjectives = 2, style = "dot", max_len = 6)
id()
id(10)
}
\author{
Rich FitzJohn
}
