% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots-ellipsis.R
\name{check_dots_empty}
\alias{check_dots_empty}
\title{Check that dots are empty}
\usage{
check_dots_empty(
  env = caller_env(),
  error = NULL,
  call = caller_env(),
  action = abort
)
}
\arguments{
\item{env}{Environment in which to look for \code{...}.}

\item{error}{An optional error handler passed to \code{\link[=try_fetch]{try_fetch()}}. Use
this e.g. to demote an error into a warning.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}

\item{action}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
\code{...} can be inserted in a function signature to force users to
fully name the details arguments. In this case, supplying data in
\code{...} is almost always a programming error. This function checks
that \code{...} is empty and fails otherwise.
}
\details{
In packages, document \code{...} with this standard tag:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ @inheritParams rlang::args_dots_empty
}\if{html}{\out{</div>}}
}
\examples{
f <- function(x, ..., foofy = 8) {
  check_dots_empty()
  x + foofy
}

# This fails because `foofy` can't be matched positionally
try(f(1, 4))

# This fails because `foofy` can't be matched partially by name
try(f(1, foof = 4))

# Thanks to `...`, it must be matched exactly
f(1, foofy = 4)

}
