/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SingleAttributeUse;
import com.thaiopensource.util.Equal;
import com.thaiopensource.xml.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalAttribute
extends SingleAttributeUse {
    private final Attribute attribute;
    private final String defaultValue;

    public OptionalAttribute(SourceLocation sourceLocation, Annotation annotation, Attribute attribute, String string) {
        super(sourceLocation, annotation);
        this.attribute = attribute;
        this.defaultValue = string;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public <T> T accept(AttributeUseVisitor<T> attributeUseVisitor) {
        return attributeUseVisitor.visitOptionalAttribute(this);
    }

    @Override
    public Name getName() {
        return this.attribute.getName();
    }

    @Override
    public SimpleType getType() {
        return this.attribute.getType();
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && ((OptionalAttribute)object).attribute.equals(this.attribute) && Equal.equal(this.defaultValue, ((OptionalAttribute)object).defaultValue);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode() ^ this.attribute.hashCode();
        if (this.defaultValue != null) {
            n ^= this.defaultValue.hashCode();
        }
        return n;
    }
}

