/*
	SRG - Squid Report Generator
	SRG header
	Copyright 2005 University of Waikato

	This file is part of SRG.

	SRG is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	SRG is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with SRG; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/
#ifndef SRG_H
#define SRG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <fstream>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <list>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include "md5.h"
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <regex.h>
#include <assert.h>

using namespace std;

#include "getline.hh"
#include "resolver.hh"

// Constants
#define HOME_URL "http://www.crc.net.nz/software/srg.php"

#define BY_NONE 0
#define BY_USER 1
#define BY_IP 2
#define BY_SUBNET 3
#define BY_MAX 3

#define SRG_CSS_FILE "style.css"
#define SRG_JS_FILE "srg.js"
#define SRG_HEADER_FILE "header.php"
#define SRG_FOOTER_FILE "footer.php"

#define CONFFILE SYSCONFDIR "/srg/srg.conf"
#define RESOURCEDIR DATADIR "/srg"

#define OUTPUT_PHP 1
#define OUTPUT_HTML 2

// Data Structures
struct summary_info {
	unsigned long long  connects;
	unsigned long long  bytesTransferred;
	unsigned long long  hits;
	unsigned long long  misses;
	unsigned long long  bytesHit;
	unsigned long long  bytesMissed;
	unsigned long long  timeSpent;
	unsigned long long  deniedHits;
};

struct filter_info {
	int by;
	char *user;
	in_addr address;
	in_addr network;
	in_addr netmask;
};

struct config_info {
	
	/* General Options */
	int debug;
	int verbose;
	int groupBy;
	int showtimes;
	int showrates;
	int nonameshowip;
	time_t startTime;
	time_t endTime;
	time_t minTime;
	time_t maxTime;
	char * title;
	char * ip2user;
	char * sitefilter;
	int sortcolumns;
	unsigned int locationStats;
    unsigned int siteStats;
	unsigned int hideDeniedOnly;
	unsigned int authenticate;
	unsigned int lookupHosts;
	unsigned int emailreport; 
	unsigned int maxreportage;
	unsigned int minimumConnects;
	
	char * accessLog;

	/* Grouping & Filtering Options */
	filter_info filter;
	in_addr groupByNetmask;
	
	/* Output Options */
	char * outputDir;
	char * outputURL;
	int outputMode;
	char * resourceDir;
	int usejs;
	char *indexfname;
	char *phpheader;
	char *phpfooter;
	char *cssfile;
	char *jsfile;

};

struct url_request {
	char *protocol;
	char *user;
	char *password;
	char *site;
	char *port;
	char *location;
};

struct log_line {
	time_t timestamp;
	unsigned int elapsedTime;
	in_addr clientAddress;
	char * resultCode;
	unsigned long long  size;
	char * requestMethod;
	url_request *request;
	char * user;
	char * hierarchyData;
	char * contentType;
};

struct ip2user_line {
	in_addr ipaddress;
	in_addr netmask;
	char *username;
};

struct exclude_netblock {
	in_addr network;
	in_addr netmask;
};

#endif
